<?php

	defined('BASEPATH') or exit('No direct script access allowed');

	$dimensions = $pdf->getPageDimensions();

	$info_right_column = '';
	$info_left_column  = '';

	$info_right_column .= '<span style="font-weight:bold;font-size:27px;">' . _l('proforma_pdf_heading') . '</span><br />';
	$info_right_column .= '<b style="color:#4e4e4e;"># ' . $proforma_number . '</b>';

	if (get_option('show_status_on_pdf_ei') == 1) {
		$info_right_column .= '<br /><span style="color:rgb(' . proforma_status_color_pdf($status) . ');text-transform:uppercase;">' . format_proforma_status($status, '', false) . '</span>';
	}

	if ($status != Invoices_model::STATUS_PAID && $status != Invoices_model::STATUS_CANCELLED && get_option('show_pay_link_to_proforma_pdf') == 1
		&& found_proforma_mode($payment_modes, $proforma->id, false)) {
		$info_right_column .= ' - <a style="color:#84c529;text-decoration:none;text-transform:uppercase;" href="' . site_url('proforma/' . $proforma->id . '/' . $proforma->hash) . '"><1b>' . _l('view_proforma_pdf_link_pay') . '</1b></a>';
	}

	// Add logo
	$info_left_column .= pdf_logo_url();

	// Write top left logo and right column info/text
	pdf_multi_row($info_left_column, $info_right_column, $pdf, ($dimensions['wk'] / 2) - $dimensions['lm']);

	$pdf->ln(10);

	$organization_info = '<div style="color:#424242;">';

	$organization_info .= format_organization_info();

	$organization_info .= '</div>';

	// Bill to
	$proforma_info = '<b>' . _l('proforma_bill_to') . '</b>';
	$proforma_info .= '<div style="color:#424242;">';
	$proforma_info .= format_customer_info($proforma, 'proforma', 'billing');
	$proforma_info .= '</div>';

	// ship to to
	if ($proforma->include_shipping == 1 && $proforma->show_shipping_on_invoice == 1) {
		$proforma_info .= '<br /><b>' . _l('ship_to') . '</b>';
		$proforma_info .= '<div style="color:#424242;">';
		$proforma_info .= format_customer_info($proforma, 'proforma', 'shipping');
		$proforma_info .= '</div>';
	}

	$proforma_info .= '<br />' . _l('proforma_data_date') . ' ' . _d($proforma->date) . '<br />';

	if (!empty($proforma->duedate)) {
		$proforma_info .= _l('proforma_data_duedate') . ' ' . _d($proforma->duedate) . '<br />';
	}

	if ($proforma->sale_agent != 0 && get_option('show_sale_agent_on_proformas') == 1) {
		$proforma_info .= _l('sale_agent_string') . ': ' . get_staff_full_name($proforma->sale_agent) . '<br />';
	}

	if ($proforma->project_id != 0 && get_option('show_project_on_proforma') == 1) {
		$proforma_info .= _l('project') . ': ' . get_project_name_by_id($proforma->project_id) . '<br />';
	}

	foreach ($pdf_custom_fields as $field) {
		$value = get_custom_field_value($proforma->id, $field['id'], 'proforma');
		if ($value == '') {
			continue;
		}
		$proforma_info .= $field['name'] . ': ' . $value . '<br />';
	}

	$left_info  = $swap == '1' ? $proforma_info : $organization_info;
	$right_info = $swap == '1' ? $organization_info : $proforma_info;

	pdf_multi_row($left_info, $right_info, $pdf, ($dimensions['wk'] / 2) - $dimensions['lm']);

	// The Table
	$pdf->Ln(hooks()->apply_filters('pdf_info_and_table_separator', 6));

	// The items table
	$items = get_items_table_data($proforma, 'proforma', 'pdf');

	$tblhtml = $items->table();
	$items_html = str_replace('{DOC_CUR}',$proforma->symbol,$tblhtml);

	$pdf->writeHTML($tblhtml, true, false, false, false, '');

	$pdf->Ln(8);

	$tbltotal = '';
	$tbltotal .= '<table cellpadding="6" style="font-size:' . ($font_size + 4) . 'px">';
	$tbltotal .= '
<tr>
    <td align="right" width="85%"><strong>' . _l('proforma_subtotal') . '</strong></td>
    <td align="right" width="15%">' . app_format_money($proforma->subtotal, $proforma->currency_name) . '</td>
</tr>';

	if (is_sale_discount_applied($proforma)) {
		$tbltotal .= '
    <tr>
        <td align="right" width="85%"><strong>' . _l('proforma_discount');
		if (is_sale_discount($proforma, 'percent')) {
			$tbltotal .= '(' . app_format_number($proforma->discount_percent, true) . '%)';
		}
		$tbltotal .= '</strong>';
		$tbltotal .= '</td>';
		$tbltotal .= '<td align="right" width="15%">-' . app_format_money($proforma->discount_total, $proforma->currency_name) . '</td>
    </tr>';
	}

	foreach ($items->taxes() as $tax) {
		$tbltotal .= '<tr>
    <td align="right" width="85%"><strong>' . $tax['taxname'] . ' (' . app_format_number($tax['taxrate']) . '%)' . '</strong></td>
    <td align="right" width="15%">' . app_format_money($tax['total_tax'], $proforma->currency_name) . '</td>
</tr>';
	}

	if ((int) $proforma->adjustment != 0) {
		$tbltotal .= '<tr>
    <td align="right" width="85%"><strong>' . _l('proforma_adjustment') . '</strong></td>
    <td align="right" width="15%">' . app_format_money($proforma->adjustment, $proforma->currency_name) . '</td>
</tr>';
	}

	$tbltotal .= '
<tr style="background-color:#f0f0f0;">
    <td align="right" width="85%"><strong>' . _l('proforma_total') . '</strong></td>
    <td align="right" width="15%">' . app_format_money($proforma->total, $proforma->currency_name) . '</td>
</tr>';

	if (count($proforma->payments) > 0 && get_option('show_total_paid_on_proforma') == 1) {
		$tbltotal .= '
    <tr>
        <td align="right" width="85%"><strong>' . _l('proforma_total_paid') . '</strong></td>
        <td align="right" width="15%">-' . app_format_money(sum_from_table(db_prefix().'proformapaymentrecords', [
				'field' => 'amount',
				'where' => [
					'proformaid' => $proforma->id,
				],
			]), $proforma->currency_name) . '</td>
    </tr>';
	}

	if (get_option('show_credits_applied_on_proforma') == 1 && $credits_applied = total_credits_applied_to_proforma($proforma->id)) {
		$tbltotal .= '
    <tr>
        <td align="right" width="85%"><strong>' . _l('applied_credits') . '</strong></td>
        <td align="right" width="15%">-' . app_format_money($credits_applied, $proforma->currency_name) . '</td>
    </tr>';
	}

	if (get_option('show_amount_due_on_proforma') == 1 && $proforma->status != Invoices_model::STATUS_CANCELLED) {
		$tbltotal .= '<tr style="background-color:#f0f0f0;">
       <td align="right" width="85%"><strong>' . _l('proforma_amount_due') . '</strong></td>
       <td align="right" width="15%">' . app_format_money($proforma->total_left_to_pay, $proforma->currency_name) . '</td>
   </tr>';
	}

	$tbltotal .= '</table>';
	$pdf->writeHTML($tbltotal, true, false, false, false, '');

	if (get_option('total_to_words_enabled') == 1) {
		// Set the font bold
		$pdf->SetFont($font_name, 'B', $font_size);
		$pdf->Cell(0, 0, _l('num_word') . ': ' . $CI->numberword->convert($proforma->total, $proforma->currency_name), 0, 1, 'C', 0, '', 0);
		// Set the font again to normal like the rest of the pdf
		$pdf->SetFont($font_name, '', $font_size);
		$pdf->Ln(4);
	}

	if (count($proforma->payments) > 0 && get_option('show_transactions_on_proforma_pdf') == 1) {
		$pdf->Ln(4);
		$border = 'border-bottom-color:#000000;border-bottom-width:1px;border-bottom-style:solid; 1px solid black;';
		$pdf->SetFont($font_name, 'B', $font_size);
		$pdf->Cell(0, 0, _l('proforma_received_payments'), 0, 1, 'L', 0, '', 0);
		$pdf->SetFont($font_name, '', $font_size);
		$pdf->Ln(4);
		$tblhtml = '<table width="100%" bgcolor="#fff" cellspacing="0" cellpadding="5" border="0">
        <tr height="20"  style="color:#000;border:1px solid #000;">
        <th width="25%;" style="' . $border . '">' . _l('proforma_payments_table_number_heading') . '</th>
        <th width="25%;" style="' . $border . '">' . _l('proforma_payments_table_mode_heading') . '</th>
        <th width="25%;" style="' . $border . '">' . _l('proforma_payments_table_date_heading') . '</th>
        <th width="25%;" style="' . $border . '">' . _l('proforma_payments_table_amount_heading') . '</th>
    </tr>';
		$tblhtml .= '<tbody>';
		foreach ($proforma->payments as $payment) {
			$payment_name = $payment['name'];
			if (!empty($payment['paymentmethod'])) {
				$payment_name .= ' - ' . $payment['paymentmethod'];
			}
			$tblhtml .= '
            <tr>
            <td>' . $payment['paymentid'] . '</td>
            <td>' . $payment_name . '</td>
            <td>' . _d($payment['date']) . '</td>
            <td>' . app_format_money($payment['amount'], $proforma->currency_name) . '</td>
            </tr>
        ';
		}
		$tblhtml .= '</tbody>';
		$tblhtml .= '</table>';
		$pdf->writeHTML($tblhtml, true, false, false, false, '');
	}

	if (found_proforma_mode($payment_modes, $proforma->id, true, true)) {
		$pdf->Ln(4);
		$pdf->SetFont($font_name, 'B', $font_size);
		$pdf->Cell(0, 0, _l('proforma_html_offline_payment'), 0, 1, 'L', 0, '', 0);
		$pdf->SetFont($font_name, '', $font_size);

		foreach ($payment_modes as $mode) {
			if (is_numeric($mode['id'])) {
				if (!is_payment_mode_allowed_for_proforma($mode['id'], $proforma->id)) {
					continue;
				}
			}
			if (isset($mode['show_on_pdf']) && $mode['show_on_pdf'] == 1) {
				$pdf->Ln(1);
				$pdf->Cell(0, 0, $mode['name'], 0, 1, 'L', 0, '', 0);
				$pdf->Ln(2);
				$pdf->writeHTMLCell('', '', '', '', $mode['description'], 0, 1, false, true, 'L', true);
			}
		}
	}

	if (!empty($proforma->clientnote)) {
		$pdf->Ln(4);
		$pdf->SetFont($font_name, 'B', $font_size);
		$pdf->Cell(0, 0, _l('proforma_note'), 0, 1, 'L', 0, '', 0);
		$pdf->SetFont($font_name, '', $font_size);
		$pdf->Ln(2);
		$pdf->writeHTMLCell('', '', '', '', $proforma->clientnote, 0, 1, false, true, 'L', true);
	}

	if (!empty($proforma->terms)) {
		$pdf->Ln(4);
		$pdf->SetFont($font_name, 'B', $font_size);
		$pdf->Cell(0, 0, _l('terms_and_conditions'), 0, 1, 'L', 0, '', 0);
		$pdf->SetFont($font_name, '', $font_size);
		$pdf->Ln(2);
		$pdf->writeHTMLCell('', '', '', '', $proforma->terms, 0, 1, false, true, 'L', true);
	}
